function [logMR,I,H,Halive]=logMRadd_Igrowth(X)
% FM APRIL 2017: with Investment growing at a constant rate
% Additive specification (instead of log additive)
% Generates log mortality rates given parameters  
%  syntax: X =  I,delta,sigma_e,alpha,mu_H,sigma_H,Hbar , growth factor

    %Parameters for simulation
    N= 200000; % 1m individuals % reduced to 100k for efficiency July29
    %global T
    T=100;                          % 100 years or pass it globally
    I1=X(1);                        % useless now?
    delta=X(2);
    sigma_e=X(3);
    alpha=X(4);
    mu_H=X(5);
    sigma_H=X(6);
    Hbar=X(7);
    
    g_I=X(8);                       % growth rate of I
    
    I=I1.*(g_I*ones(1,T)).^(0:99);     % Path of investment

    % Initialization
    H=zeros(N,T);
    H(:,1)=mu_H+sigma_H.*randn(N,1);
    deathyear=T*ones(N,1);          %will record death year
    alive=ones(N,T);                %record survivors
    Nt=N*ones(T,1);                 %count surviving population
    MR=zeros(1,T);

    % Iteration
    justdied=find(H(:,1)<Hbar); %find those who just died
    mortality=length(justdied); %count the deaths
    Nt=N-mortality; 
    deathyear(justdied)=1; %record infant mortality rate
    alive(justdied,1)=0;
    MR(1,1)=mortality/N; % here maybe 

    for t=2:T
        Eps=sigma_e*randn(N,1); %draw shock
        H(:,t)=H(:,t-1)+(I(t)-delta*(t^alpha)+Eps);
        alive(:,t)=alive(:,t-1)==1 & H(:,t)>Hbar;
        justdied=find(alive(:,t-1)~=alive(:,t));
        mortality=length(justdied);
        Nt=Nt-mortality;
        deathyear(justdied)=t; %record death year
        MR(1,t)=mortality/sum(alive(:,t-1));
        %if  MR(1,t)==0
        %     MR(1,t)=1;         % NO, screws up optimization, prevent infinity when taking log
        %end
    end

    logMR=min(log(MR'),zeros(T,1));  
    %logMR=max(log(MR'),log(ones(1,T)./Nt)');     % floor: 1 person dies
    logMR=max(log(MR'),log((1/N)*ones(1,T)'));     % floor: 1 person dies

    Halive=H.*alive;
    %CHECKS AND FIGURES
    % mortality                     OK
    %{
    plot(log(MR));
    title('log mortality, 1m indivdiuals');
    %}

end
